<?php
/**
 * The Vintech_Register initiate the theme engine
 */

if ( !defined( 'ABSPATH' ) ) 
    exit; // Exit if accessed directly

class Vintech_Register {

    /**
     * Variables required for the theme
     *
     * @since 1.0.0
     * @type string
     */
    protected $theme_slug = null;
    protected $theme_name = null;
    protected $version = null;
    protected $author = null;

    /**
     * Initialize the class.
     *
     * @since 1.0.0
     */
    public function __construct( $config = array() ) {
        $config = wp_parse_args( $config, array(
            'theme_slug' => get_template(),
            'theme_name' => wp_get_theme()->get( 'Name' ),
            'version'    => wp_get_theme()->get( 'Version' ),
            'author'     => 'Pixelart team',
        ) );

        // Set config arguments
        $this->theme_slug = sanitize_key( $config['theme_slug'] );
        $this->theme_name = $config['theme_name'];
        $this->version    = $config['version'];
        $this->author     = $config['author'];

        // Populate version fallback
        if ( empty( $config['version'] ) ) {
            $theme = wp_get_theme( $this->theme_slug );
            $this->version = $theme->get( 'Version' );
        }

        add_action( 'admin_init', array( $this, 'updater' ), 14 );
        add_filter( 'http_request_args', array( $this, 'disable_wporg_request' ), 5, 2 );
    }

    /**
     * Creates the updater class.
     *
     * @since 1.0.0
     */
    function updater() {
        if ( !class_exists( 'Vintech_Updater' ) ) {
            // Load our custom theme updater
            $updater_path = get_template_directory() . '/inc/admin/updater/updater-class.php';
            if ( file_exists( $updater_path ) ) {
                include( $updater_path );
            }
        }

        if ( class_exists( 'Vintech_Updater' ) ) {
            new Vintech_Updater(
                array(
                    'version' => $this->version,
                ),
                array()
            );
        }
    }

    /**
     * Disable requests to wp.org repository for this theme.
     *
     * @since 1.0.0
     */
    function disable_wporg_request( $r, $url ) {
        // If it's not a theme update request, bail.
        if ( 0 !== strpos( $url, 'https://api.wordpress.org/themes/update-check/1.1/' ) ) {
            return $r;
        }

        // Decode the JSON response
        $themes = json_decode( $r['body']['themes'] );

        // Remove the active parent and child themes from the check
        $parent = get_option( 'template' );
        $child = get_option( 'stylesheet' );
        unset( $themes->themes->$parent );
        unset( $themes->themes->$child );

        // Encode the updated JSON response
        $r['body']['themes'] = json_encode( $themes );

        return $r;
    }
}

new Vintech_Register;